/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Calculator {
    private static Calculator instance;
    private CalculatorGUI calculatorGUI;
    public static String text;
    public static String Ans;
    public static int count;

    private Calculator(String txt) {
        System.out.println("Calculator started!");
        text = txt;
    }

    public static Calculator getInstance(String s) {
        if (instance == null) {
            instance = new Calculator(text);
        }
        instance.setExpression(s);
        return instance;
    }

    private String getText() {
        return text;
    }

    public String lastAns() {
        return Ans;
    }

    public String calculate() {
        this.replaceAnsInText();
        String tmp = text;
        if (!this.isValid(text)) {
            return "Math Error , [AC] : Cancel";
        }
        ArrayList<String> elements = Calculator.parseExpression(text);
        if ((text = Calculator.evaluate(elements)).equals("Infinity") || text.equals("NaN") || text.equals("-Infinity")) {
            return "Math Error , [AC] : Cancel";
        }
        if (!text.equals("")) {
            Ans = text;
            System.out.println("Equation No " + count++ + ": " + tmp + " = " + Ans);
        }
        return text;
    }

    public void replaceAnsInText() {
        if (Ans != null) {
            text = text.replace("Ans", Ans);
        }
    }

    public static boolean isOperator(String s) {
        return s.equals("+") || s.equals("-") || s.equals("\u00d7") || s.equals("/") || s.equals("^") || Objects.equals(s, "(") || Objects.equals(s, ")");
    }

    public static boolean isFunction(String s) {
        return s.equals("sin") || s.equals("cos") || s.equals("tan") || s.equals("sqrt") || s.equals("ln") || s.equals("log");
    }

    public static String evaluate(ArrayList<String> expression) {
        if (expression.isEmpty()) {
            return "";
        }
        Stack<String> stack = new Stack<String>();
        LinkedList<String> output = new LinkedList<String>();
        for (String s2 : expression) {
            if (!Calculator.isOperator(s2) && !Calculator.isFunction(s2)) {
                output.add(s2);
                continue;
            }
            if (s2.equals("(")) {
                stack.push(s2);
                continue;
            }
            if (s2.equals(")")) {
                while (!stack.isEmpty() && !((String)stack.peek()).equals("(")) {
                    output.add((String)stack.pop());
                }
                if (stack.isEmpty()) continue;
                stack.pop();
                continue;
            }
            if (!Calculator.isOperator(s2) && !Calculator.isFunction(s2)) continue;
            while (!stack.isEmpty() && (Calculator.isOperator((String)stack.peek()) || Calculator.isFunction((String)stack.peek())) && Calculator.precedence(s2) <= Calculator.precedence((String)stack.peek())) {
                output.add((String)stack.pop());
            }
            stack.push(s2);
        }
        while (!stack.isEmpty()) {
            output.add((String)stack.pop());
        }
        output.removeIf(s -> s.equals("(") || s.equals(")"));
        return Calculator.calculateRPN(output);
    }

    public static String calculateRPN(LinkedList<String> rpn) {
        Stack<Double> stack = new Stack<Double>();
        System.out.println(rpn);
        while (!rpn.isEmpty()) {
            String token = rpn.poll();
            if (!Calculator.isOperator(token) && !Calculator.isFunction(token)) {
                stack.push(Double.parseDouble(token));
                continue;
            }
            double a = (Double)stack.pop();
            switch (token) {
                case "+": {
                    double b = (Double)stack.pop();
                    stack.push(a + b);
                    break;
                }
                case "-": {
                    double b = (Double)stack.pop();
                    stack.push(b - a);
                    break;
                }
                case "\u00d7": {
                    double b = (Double)stack.pop();
                    stack.push(a * b);
                    break;
                }
                case "/": {
                    double b = (Double)stack.pop();
                    if (a == 0.0) {
                        return "Math Error , [AC] : Cancel";
                    }
                    stack.push(b / a);
                    break;
                }
                case "^": {
                    double b = (Double)stack.pop();
                    stack.push(Math.pow(b, a));
                    break;
                }
                case "sin": {
                    stack.push(Math.sin(a));
                    break;
                }
                case "cos": {
                    stack.push(Math.cos(a));
                    break;
                }
                case "tan": {
                    stack.push(Math.tan(a));
                    break;
                }
                case "sqrt": {
                    stack.push(Math.sqrt(a));
                    break;
                }
                case "ln": {
                    stack.push(Math.log(a));
                    break;
                }
                case "log": {
                    stack.push(Math.log10(a));
                }
            }
        }
        double result = (Double)stack.pop();
        if (result % 1.0 == 0.0) {
            return String.valueOf(result).substring(0, String.valueOf(result).length() - 2);
        }
        return String.valueOf(result);
    }

    private static int intValue(Double peek) {
        return (int)peek.doubleValue();
    }

    public static int precedence(String operator) {
        return switch (operator) {
            case "+", "-" -> 1;
            case "*", "/" -> 2;
            case "sin", "cos", "tan", "sqrt", "log", "ln" -> 3;
            case "^" -> 4;
            default -> 0;
        };
    }

    public static ArrayList<String> parseExpression(String text) {
        ArrayList<String> elements = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\d+\\.?\\d*|[-+\u00d7/^()]|\\b(sin|cos|tan|sqrt|ln|log)\\b|\\(");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            elements.add(matcher.group());
        }
        return elements;
    }

    public static void printElements(ArrayList<String> elements) {
        System.out.println(text);
        for (String element : elements) {
            System.out.println(element);
        }
    }

    public boolean isValid(String currentText) {
        Stack<Character> stack = new Stack<Character>();
        if (currentText.contains("Ans") && Ans == null) {
            return false;
        }
        for (int i2 = 0; i2 < currentText.length(); ++i2) {
            char c = currentText.charAt(i2);
            if (c == '(') {
                if (i2 != currentText.length() - 1 && (currentText.charAt(i2 + 1) == ')' || Calculator.isOperator(currentText.substring(i2 + 1, Math.min(i2 + 4, currentText.length()))))) {
                    return false;
                }
                stack.push(Character.valueOf(c));
                continue;
            }
            if (c == ')') {
                if (i2 != currentText.length() - 1 && currentText.charAt(i2 + 1) >= '0' && currentText.charAt(i2 + 1) <= '9') {
                    return false;
                }
                if (stack.isEmpty()) {
                    return false;
                }
                stack.pop();
                continue;
            }
            if (Calculator.isOperator(String.valueOf(c))) {
                if (i2 == 0 || i2 == currentText.length() - 1) {
                    return false;
                }
                if (!Calculator.isOperator(currentText.substring(Math.max(0, i2 - 1), i2 + 1)) && !Calculator.isOperator(currentText.substring(i2 + 1, Math.min(i2 + 4, currentText.length())))) continue;
                return false;
            }
            if (c == 's' || c == 'c' || c == 't') {
                if (i2 + 3 >= currentText.length() || !Calculator.isFunction(currentText.substring(i2, i2 + 2))) continue;
                return false;
            }
            if (c != 'l' || currentText.charAt(i2 + 1) != 'o') continue;
            if (i2 + 2 < currentText.length() && Calculator.isFunction(currentText.substring(i2, i2 + 1))) {
                return false;
            }
            if (currentText.charAt(i2 + 1) != 'o' || i2 + 1 >= currentText.length() || !Calculator.isFunction(currentText.substring(i2, i2))) continue;
            return false;
        }
        return stack.isEmpty();
    }

    public String toString(double number) {
        return Double.toString(number);
    }

    public int toInt(String number) {
        return Integer.parseInt(number);
    }

    public void setExpression(String s) {
        text = s;
    }

    static {
        text = "";
        Ans = "";
        count = 1;
    }
}

