/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CalculatorGUI
extends JFrame {
    private JTextField displayField;
    private boolean lastEquals = false;

    public CalculatorGUI() {
        super("Scientific Calculator");
        String[] buttonLabels;
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.displayField = new JTextField();
        this.displayField.setEditable(false);
        this.displayField.setHorizontalAlignment(2);
        this.displayField.setFont(new Font("Arial", 1, 24));
        this.displayField.setPreferredSize(new Dimension(300, 75));
        this.add((Component)this.displayField, "North");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(6, 6, 8, 8));
        for (String label : buttonLabels = new String[]{"(", ")", "x\u00b2", "ln(", "log\u2081\u2080(", "sin(", "cos(", "tan(", "sqrt(", "^", "7", "8", "9", "DEL", "AC", "4", "5", "6", "\u00d7", "/", "1", "2", "3", "+", "-", "0", ".", "\u00d710\u02e3", "Ans", "="}) {
            JButton button = new JButton(label);
            button.addActionListener(new ButtonClickListener());
            Font buttonFont = new Font("Times New Roman", 1, 16);
            button.setFont(buttonFont);
            Dimension buttonSize = new Dimension(50, 50);
            button.setPreferredSize(buttonSize);
            buttonsPanel.add(button);
        }
        this.add((Component)buttonsPanel, "Center");
        this.setSize(315, 400);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    String getDisplayFieldText() {
        return this.displayField.getText();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new CalculatorGUI());
    }

    private class ButtonClickListener
    implements ActionListener {
        private ButtonClickListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CalculatorGUI.this.displayField.getText().equals("Math Error , [AC] : Cancel")) {
                if (((JButton)e.getSource()).getText().equals("AC")) {
                    CalculatorGUI.this.displayField.setText("");
                }
                return;
            }
            if (CalculatorGUI.this.lastEquals) {
                CalculatorGUI.this.displayField.setText("");
                CalculatorGUI.this.lastEquals = false;
            }
            if (((JButton)e.getSource()).getText().equals("=")) {
                String currentText = CalculatorGUI.this.displayField.getText();
                Calculator calculator = Calculator.getInstance(currentText);
                CalculatorGUI.this.displayField.setText(calculator.calculate());
                CalculatorGUI.this.lastEquals = true;
                return;
            }
            if (((JButton)e.getSource()).getText().equals("AC")) {
                CalculatorGUI.this.displayField.setText("");
                return;
            }
            if (((JButton)e.getSource()).getText().equals("DEL")) {
                String currentText = CalculatorGUI.this.displayField.getText();
                if (Objects.equals(currentText, "")) {
                    return;
                }
                currentText = currentText.endsWith("sin(") || currentText.endsWith("cos(") || currentText.endsWith("tan(") || currentText.endsWith("log(") ? currentText.substring(0, currentText.length() - 4) : (currentText.endsWith("sqrt(") ? currentText.substring(0, currentText.length() - 5) : (currentText.endsWith("ln(") || currentText.endsWith("Ans") ? currentText.substring(0, currentText.length() - 3) : currentText.substring(0, currentText.length() - 1)));
                CalculatorGUI.this.displayField.setText(currentText);
                return;
            }
            if (((JButton)e.getSource()).getText().equals("x\u00b2")) {
                String currentText = CalculatorGUI.this.displayField.getText();
                CalculatorGUI.this.displayField.setText(currentText + "^(2)");
                return;
            }
            if (((JButton)e.getSource()).getText().equals("\u00d710\u02e3")) {
                String currentText = CalculatorGUI.this.displayField.getText();
                CalculatorGUI.this.displayField.setText(currentText + "\u00d710^(");
                return;
            }
            if (((JButton)e.getSource()).getText().equals("log\u2081\u2080(")) {
                String currentText = CalculatorGUI.this.displayField.getText();
                CalculatorGUI.this.displayField.setText(currentText + "log(");
                return;
            }
            String buttonLabel = ((JButton)e.getSource()).getText();
            String currentText = CalculatorGUI.this.displayField.getText();
            CalculatorGUI.this.displayField.setText(currentText + buttonLabel);
        }
    }
}

