/*
 * Decompiled with CFR 0.152.
 */
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class CalculatorTest {
    private static Calculator calculator;

    CalculatorTest() {
    }

    @BeforeAll
    static void initAll() {
        calculator = Calculator.getInstance("");
    }

    @Test
    void testSin() {
        calculator.setExpression("sin(0)");
        Assertions.assertEquals("0", calculator.calculate());
    }

    @Test
    void testCos() {
        calculator.setExpression("cos(0)");
        Assertions.assertEquals("1", calculator.calculate());
    }

    @Test
    void testTan() {
        calculator.setExpression("tan(0)");
        Assertions.assertEquals("0", calculator.calculate());
    }

    @Test
    void testSqrt() {
        calculator.setExpression("sqrt(4)");
        Assertions.assertEquals("2", calculator.calculate());
    }

    @Test
    void testLn() {
        calculator.setExpression("ln(1)");
        Assertions.assertEquals("0", calculator.calculate());
    }

    @Test
    void testLog() {
        calculator.setExpression("log\u2081\u2080(1)");
        Assertions.assertEquals("0", calculator.calculate());
    }

    @Test
    void testPower() {
        calculator.setExpression("2^3");
        Assertions.assertEquals("8", calculator.calculate());
    }

    @Test
    void testComplexExpression1() {
        calculator.setExpression("sin(0)+cos(0)");
        Assertions.assertEquals("1", calculator.calculate());
    }

    @Test
    void testComplexExpression2() {
        calculator.setExpression("sqrt(4)^2");
        Assertions.assertEquals("4", calculator.calculate());
    }

    @Test
    void testComplexExpression3() {
        calculator.setExpression("ln(1+1)");
        Assertions.assertEquals("0.6931471805599453", calculator.calculate());
    }

    @Test
    void testLongExpression1() {
        calculator.setExpression("sin(0)+cos(0)+tan(0)+sqrt(4)+ln(1)+log(1)+2^3");
        Assertions.assertEquals("11", calculator.calculate());
    }

    @Test
    void testLongExpression2() {
        calculator.setExpression("sin(0)\u00d7cos(0)\u00d7tan(0)\u00d7sqrt(4)\u00d7ln(1)\u00d7log(1)\u00d72^3");
        Assertions.assertEquals("0", calculator.calculate());
    }

    @Test
    void testLongExpression3() {
        calculator.setExpression("sin(0)-cos(0)-tan(0)-sqrt(4)-ln(1)-log(1)-2^3");
        Assertions.assertEquals("-11", calculator.calculate());
    }

    @Test
    void testLongExpression4() {
        calculator.setExpression("sin(0)/cos(0)/tan(0)/sqrt(4)/ln(1)/log(1)/2^3");
        Assertions.assertEquals("Math Error , [AC] : Cancel", calculator.calculate());
    }

    @Test
    void testLongExpression5() {
        calculator.setExpression("sin(0)+cos(0)\u00d7tan(0)-sqrt(4)/ln(1)+log(1)-2^3");
        Assertions.assertEquals("Math Error , [AC] : Cancel", calculator.calculate());
    }

    @Test
    void testComplexExpression4() {
        calculator.setExpression("(sin(0)+cos(0))/2");
        Assertions.assertEquals("0.5", calculator.calculate());
    }

    @Test
    void testComplexExpression5() {
        calculator.setExpression("sqrt((4+16)/2)");
        Assertions.assertEquals("3.1622776601683795", calculator.calculate());
    }

    @Test
    void testComplexExpression6() {
        calculator.setExpression("ln((1+1)/(1+1-1))");
        Assertions.assertEquals("0.6931471805599453", calculator.calculate());
    }

    @Test
    void testComplexExpression7() {
        calculator.setExpression("log(100/(10+10))");
        Assertions.assertEquals("0.6989700043360189", calculator.calculate());
    }

    @Test
    void testComplexExpression8() {
        calculator.setExpression("(2^3)/(4-2)");
        Assertions.assertEquals("4", calculator.calculate());
    }

    @Test
    void testComplexExpression9() {
        calculator.setExpression("((sin(0)+cos(0))\u00d7tan(0))/sqrt(4)");
        Assertions.assertEquals("0", calculator.calculate());
    }

    @Test
    void testComplexExpression10() {
        calculator.setExpression("ln(1/((1+1)-1))");
        Assertions.assertEquals("0", calculator.calculate());
    }

    @Test
    void testVeryComplexExpression1() {
        calculator.setExpression("tan(4 + sin(4)) + 2^(sin(3^2))");
        Assertions.assertEquals("1.4325942606234885", calculator.calculate());
    }

    @Test
    void testVeryComplexExpression2() {
        calculator.setExpression("cos(27 + sqrt(5)) / ln(1 + 4 + sqrt(7))");
        Assertions.assertEquals("-0.28124697664869", calculator.calculate());
    }

    @Test
    void testVeryComplexExpression3() {
        calculator.setExpression("sin(4 + cos(3)) / (1 + cos(3) + sqrt(3))");
        Assertions.assertEquals("0.07531651081592326", calculator.calculate());
    }

    @Test
    void testVeryComplexExpression4() {
        calculator.setExpression("ln(sin(3) + tan(54)) \u00d7 tan(7^(sqrt(2)))");
        Assertions.assertEquals("0.007181043111533832", calculator.calculate());
    }

    @Test
    void testVeryComplexExpression5() {
        calculator.setExpression("cos(ln(3) + sin(4)) / tan(5 + sqrt(5))");
        Assertions.assertEquals("0.6696460076786583", calculator.calculate());
    }
}

