/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GUI_for_chess_like_games
extends JFrame {
    private static final int BUTTON_SIZE = 55;
    private static final int FONT_SIZE = 20;
    private final JButton[][] buttons;
    private final int BOARD_SIZE;
    private JButton selectedButton = null;
    private Color selectedColor = null;
    private final PlayableLogic gameLogic;
    private final JLabel turnLabel = new JLabel("Player 2's Turn");
    private final JLabel playerTowWinsLabel = new JLabel("\u265f Player 2 Wins: 0");
    private final JLabel playerOneWinsLabel = new JLabel("\u2659 Player 1 Wins: 0");
    private final JPanel mainPanel = new JPanel(new BorderLayout());

    public GUI_for_chess_like_games(PlayableLogic gameLogic, String title) {
        this.gameLogic = gameLogic;
        this.BOARD_SIZE = gameLogic.getBoardSize();
        this.setTitle(title);
        this.setDefaultCloseOperation(3);
        JPanel topPanel = new JPanel(new FlowLayout(1));
        JButton backButton = new JButton("Back");
        topPanel.add((Component)backButton, "West");
        backButton.addActionListener(e -> {
            gameLogic.undoLastMove();
            this.updateBoard();
        });
        JPanel leftLabelPanel = new JPanel();
        JPanel rightLabelPanel = new JPanel();
        leftLabelPanel.add(this.playerTowWinsLabel);
        rightLabelPanel.add(this.playerOneWinsLabel);
        topPanel.add((Component)leftLabelPanel, "West");
        topPanel.add((Component)this.turnLabel, "Center");
        topPanel.add((Component)rightLabelPanel, "East");
        this.add((Component)topPanel, "North");
        this.mainPanel.setLayout(new GridLayout(this.BOARD_SIZE, this.BOARD_SIZE));
        this.buttons = new JButton[this.BOARD_SIZE][this.BOARD_SIZE];
        JButton resetButton = new JButton("Reset");
        topPanel.add((Component)resetButton, "East");
        resetButton.addActionListener(e -> this.resetGame());
    }

    private void twoButtonsListener(Position srcPosition, Position destPosition) {
        if (this.gameLogic.move(srcPosition, destPosition)) {
            this.updateBoard();
            if (this.gameLogic.isGameFinished()) {
                this.resetGame();
            }
        }
    }

    private void updateBoard() {
        if (this.gameLogic.isSecondPlayerTurn()) {
            this.turnLabel.setText("Player 2's Turn");
        } else {
            this.turnLabel.setText("Player 1's Turn");
        }
        for (int row = 0; row < this.BOARD_SIZE; ++row) {
            for (int col = 0; col < this.BOARD_SIZE; ++col) {
                Piece piece = this.gameLogic.getPieceAtPosition(new Position(row, col));
                if (piece != null) {
                    String type = piece.getType();
                    this.buttons[row][col].setText(type);
                    if (piece.getOwner().isPlayerOne()) {
                        this.buttons[row][col].setForeground(Color.BLUE);
                        continue;
                    }
                    this.buttons[row][col].setForeground(new Color(165, 42, 42));
                    continue;
                }
                this.buttons[row][col].setText("");
            }
        }
        this.updateWinsLabels(this.gameLogic.getSecondPlayer().getWins(), this.gameLogic.getFirstPlayer().getWins());
    }

    private void updateWinsLabels(int attackerWins, int defenderWins) {
        this.playerTowWinsLabel.setText("\u265f Player 2 Wins: " + attackerWins);
        this.playerOneWinsLabel.setText("\u2659 Player 1 Wins: " + defenderWins);
    }

    public void start() {
        for (int col = 0; col < this.BOARD_SIZE; ++col) {
            for (int row = 0; row < this.BOARD_SIZE; ++row) {
                this.buttons[row][col] = new JButton();
                this.buttons[row][col].setPreferredSize(new Dimension(55, 55));
                Font chessFont = new Font("DejaVu Sans", 0, 20);
                this.buttons[row][col].setFont(chessFont);
                if ((row + col) % 2 != 0) {
                    this.buttons[row][col].setBackground(new Color(184, 134, 11));
                } else {
                    this.buttons[row][col].setBackground(Color.WHITE);
                }
                if (row % (this.BOARD_SIZE - 1) == 0 && col % (this.BOARD_SIZE - 1) == 0) {
                    this.buttons[row][col].setBackground(new Color(189, 183, 107));
                }
                this.buttons[row][col].setBorderPainted(false);
                if (this.gameLogic.getPieceAtPosition(new Position(row, col)) != null) {
                    Piece piece = this.gameLogic.getPieceAtPosition(new Position(row, col));
                    String type = piece.getType();
                    this.buttons[row][col].setText(type);
                    if (piece.getOwner().isPlayerOne()) {
                        this.buttons[row][col].setForeground(Color.BLUE);
                    } else {
                        this.buttons[row][col].setForeground(new Color(165, 42, 42));
                    }
                }
                this.mainPanel.add(this.buttons[row][col]);
                this.buttons[row][col].putClientProperty("row", row);
                this.buttons[row][col].putClientProperty("col", col);
                this.buttons[row][col].addActionListener(e -> {
                    JButton clickedButton = (JButton)e.getSource();
                    if (this.selectedButton == null) {
                        int colIndexOld;
                        int rowIndexOld = (Integer)clickedButton.getClientProperty("row");
                        Position p = new Position(rowIndexOld, colIndexOld = ((Integer)clickedButton.getClientProperty("col")).intValue());
                        if (this.gameLogic.getPieceAtPosition(p) != null) {
                            this.selectedButton = clickedButton;
                            this.selectedColor = this.selectedButton.getBackground();
                            this.selectedButton.setBackground(Color.GREEN);
                        }
                    } else if (this.selectedButton == clickedButton) {
                        this.selectedButton.setBackground(this.selectedColor);
                        this.selectedButton = null;
                    } else {
                        this.selectedButton.setBackground(this.selectedColor);
                        int rowIndexOld = (Integer)this.selectedButton.getClientProperty("row");
                        int colIndexOld = (Integer)this.selectedButton.getClientProperty("col");
                        Position oldPosition = new Position(rowIndexOld, colIndexOld);
                        this.selectedButton = null;
                        int rowIndex = (Integer)clickedButton.getClientProperty("row");
                        int colIndex = (Integer)clickedButton.getClientProperty("col");
                        Position newPosition = new Position(rowIndex, colIndex);
                        this.twoButtonsListener(oldPosition, newPosition);
                    }
                });
            }
        }
        this.getContentPane().add(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void resetGame() {
        this.gameLogic.reset();
        this.updateBoard();
        this.turnLabel.setText("Player 2's Turn");
        if (this.selectedButton != null) {
            this.selectedButton.setBackground(this.selectedColor);
            this.selectedButton = null;
        }
    }
}

