/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GameLogic
implements PlayableLogic {
    public static int BOARD_SIZE = 11;
    private ConcretePiece[][] board;
    private Position[][] positions;
    private final ConcretePlayer attacker;
    private final ConcretePlayer defender;
    private boolean gameFinished;
    private boolean attackerTurn = true;
    private final List<ConcretePiece> pieces = new ArrayList<ConcretePiece>();
    private Stack<Move> moveHistory;
    private int attackerDeaths;
    private List<ConcretePiece> capturedPieces;

    public GameLogic() {
        this.attacker = new ConcretePlayer(false);
        this.defender = new ConcretePlayer(true);
        this.positions = new Position[BOARD_SIZE][BOARD_SIZE];
        this.reset();
    }

    @Override
    public boolean move(Position a, Position b) {
        ConcretePiece movingPiece;
        boolean attackerTurn = this.isSecondPlayerTurn();
        boolean defenderPosition = this.getPieceAtPosition(a).getOwner().isPlayerOne();
        if (this.illegalMove(a, b) || attackerTurn && defenderPosition || !attackerTurn && !defenderPosition) {
            return false;
        }
        this.capturedPieces = new ArrayList<ConcretePiece>();
        int x = a.getX();
        int y = a.getY();
        this.board[b.getX()][b.getY()] = movingPiece = this.board[x][y];
        movingPiece.update(b);
        int xB = b.getX();
        int yB = b.getY();
        if (this.positions[xB][yB] == null) {
            this.positions[xB][yB] = new Position(xB, yB);
        }
        this.positions[xB][yB].raisePiece(movingPiece);
        this.board[x][y] = null;
        this.checkCaptureAndVictory(b);
        this.attackerTurn = !attackerTurn;
        this.moveHistory.push(new Move(b, this.capturedPieces));
        return true;
    }

    private boolean illegalMove(Position a, Position b) {
        int bY;
        boolean sameRow;
        if (this.board[a.getX()][a.getY()] == null || this.board[b.getX()][b.getY()] != null || a.getX() != b.getX() && a.getY() != b.getY() || this.isCorner(b) && !(this.board[a.getX()][a.getY()] instanceof King)) {
            return true;
        }
        int aX = a.getX();
        int bX = b.getX();
        int aY = a.getY();
        boolean bl = sameRow = aY == (bY = b.getY());
        if (sameRow) {
            int s = Math.min(aX, bX);
            int t = Math.max(aX, bX);
            for (int i = s + 1; i < t; ++i) {
                if (this.board[i][aY] == null) continue;
                return true;
            }
        } else {
            int s = Math.min(aY, bY);
            int t = Math.max(aY, bY);
            for (int i = s + 1; i < t; ++i) {
                if (this.board[aX][i] == null) continue;
                return true;
            }
        }
        return false;
    }

    private void checkCaptureAndVictory(Position newPosition) {
        int y;
        if (this.isCorner(newPosition)) {
            this.declareVictoryAndPrintStats(true);
            return;
        }
        int x = newPosition.getX();
        if (this.board[x][y = newPosition.getY()] instanceof Pawn) {
            int xLeft1 = x - 1;
            int xLeft2 = x - 2;
            if (x != 0 && (xLeft1 == 0 || this.board[xLeft2][y] != null && !(this.board[xLeft2][y] instanceof King) && this.board[xLeft2][y].getOwner().isPlayerOne() == this.board[x][y].getOwner().isPlayerOne() || this.isCorner(new Position(xLeft2, y))) && this.board[xLeft1][y] != null && this.board[xLeft1][y].getOwner().isPlayerOne() != this.board[x][y].getOwner().isPlayerOne() && this.capture(x, y, xLeft1, y)) {
                return;
            }
            int xRight1 = x + 1;
            int xRight2 = x + 2;
            if ((xRight1 == this.board.length - 1 || xRight2 < this.board.length && this.board[xRight2][y] != null && !(this.board[xRight2][y] instanceof King) && this.board[xRight2][y].getOwner().isPlayerOne() == this.board[x][y].getOwner().isPlayerOne() || this.isCorner(new Position(xRight2, y))) && xRight1 < this.board.length && this.board[xRight1][y] != null && this.board[xRight1][y].getOwner().isPlayerOne() != this.board[x][y].getOwner().isPlayerOne() && this.capture(x, y, xRight1, y)) {
                return;
            }
            int yUp1 = y - 1;
            int yUp2 = y - 2;
            if (y != 0 && (yUp1 == 0 || this.board[x][yUp2] != null && !(this.board[x][yUp2] instanceof King) && this.board[x][yUp2].getOwner().isPlayerOne() == this.board[x][y].getOwner().isPlayerOne() || this.isCorner(new Position(x, yUp2))) && this.board[x][yUp1] != null && this.board[x][yUp1].getOwner().isPlayerOne() != this.board[x][y].getOwner().isPlayerOne() && this.capture(x, y, x, yUp1)) {
                return;
            }
            int yDown1 = y + 1;
            int yDown2 = y + 2;
            if ((yDown1 == this.board[0].length - 1 || yDown2 < this.board[0].length && this.board[x][yDown2] != null && !(this.board[x][yDown2] instanceof King) && this.board[x][yDown2].getOwner().isPlayerOne() == this.board[x][y].getOwner().isPlayerOne() || this.isCorner(new Position(x, yDown2))) && yDown1 < this.board[0].length && this.board[x][yDown1] != null && this.board[x][yDown1].getOwner().isPlayerOne() != this.board[x][y].getOwner().isPlayerOne()) {
                this.capture(x, y, x, yDown1);
            }
        }
        if (this.attackerDeaths == 24) {
            this.declareVictoryAndPrintStats(true);
        }
    }

    private boolean capture(int x, int y, int x1, int y1) {
        if (this.board[x1][y1] instanceof Pawn) {
            this.capturedPieces.add(this.board[x1][y1]);
            if (!this.board[x1][y1].getOwner().isPlayerOne()) {
                ++this.attackerDeaths;
            }
            this.board[x1][y1] = null;
            ((Pawn)this.board[x][y]).kill();
        } else if (this.isKingSurrounded(x1, y1)) {
            this.declareVictoryAndPrintStats(false);
            return true;
        }
        return false;
    }

    private void declareVictoryAndPrintStats(boolean isDefenderWon) {
        this.gameFinished = true;
        ConcretePlayer winner = isDefenderWon ? this.defender : this.attacker;
        winner.win();
        this.pieces.sort((piece1, piece2) -> {
            int defenderComparison = Boolean.compare(piece1.getOwner().isPlayerOne(), piece2.getOwner().isPlayerOne());
            if (defenderComparison != 0) {
                return isDefenderWon ? -defenderComparison : defenderComparison;
            }
            int stepsComparison = Integer.compare(piece1.getPositionHistory().size(), piece2.getPositionHistory().size());
            if (stepsComparison != 0) {
                return stepsComparison;
            }
            return Integer.compare(piece1.getNumber(), piece2.getNumber());
        });
        this.printStats(this.pieces, o -> o.getPositionHistory().size() > 1, ConcretePiece::getPositionHistory);
        List pawns = this.pieces.stream().filter(piece -> piece instanceof Pawn).map(piece -> (Pawn)piece).sorted((piece1, piece2) -> {
            int killsC = Integer.compare(piece2.getKills(), piece1.getKills());
            return this.compareByOrder(isDefenderWon, (ConcretePiece)piece1, (ConcretePiece)piece2, killsC);
        }).collect(Collectors.toList());
        this.printStats(pawns, o -> o.getKills() > 0, Pawn::getKillsStr);
        this.pieces.sort((piece1, piece2) -> {
            int ditComp = Integer.compare(piece2.getDist(), piece1.getDist());
            return this.compareByOrder(isDefenderWon, (ConcretePiece)piece1, (ConcretePiece)piece2, ditComp);
        });
        this.printStats(this.pieces, o -> o.getDist() > 0, ConcretePiece::getDistStr);
        List<Position> positionList = Stream.of(this.positions).flatMap(Stream::of).filter(Objects::nonNull).sorted((position1, position2) -> {
            int ditComp = Integer.compare(position2.getPieceSize(), position1.getPieceSize());
            if (ditComp != 0) {
                return ditComp;
            }
            int xComp = Integer.compare(position1.getX(), position2.getX());
            if (xComp != 0) {
                return xComp;
            }
            return Integer.compare(position1.getY(), position2.getY());
        }).toList();
        this.printStats(positionList, position -> position.getPieceSize() > 1, Position::piecesStr);
        this.pieces.clear();
        this.positions = new Position[BOARD_SIZE][BOARD_SIZE];
    }

    private int compareByOrder(boolean isDefenderWon, ConcretePiece piece1, ConcretePiece piece2, int comp) {
        if (comp != 0) {
            return comp;
        }
        int numCom = Integer.compare(piece1.getNumber(), piece2.getNumber());
        if (numCom != 0) {
            return numCom;
        }
        int defenderComparison = Boolean.compare(piece1.getOwner().isPlayerOne(), piece2.getOwner().isPlayerOne());
        return isDefenderWon ? -defenderComparison : defenderComparison;
    }

    private <T, R> void printStats(Collection<T> collection, Function<T, Boolean> condition, Function<T, R> function) {
        for (T p : collection) {
            if (!condition.apply(p).booleanValue()) continue;
            System.out.print(p);
            System.out.println(function.apply(p).toString());
        }
        for (int i = 0; i < 75; ++i) {
            System.out.print("*");
        }
        System.out.println();
    }

    private boolean isKingSurrounded(int x, int y) {
        int enemyCount = 0;
        if (x > 0 && this.board[x - 1][y] != null && this.board[x - 1][y].getOwner().isPlayerOne() != this.board[x][y].getOwner().isPlayerOne()) {
            ++enemyCount;
        }
        if (x < this.board.length - 1 && this.board[x + 1][y] != null && this.board[x + 1][y].getOwner().isPlayerOne() != this.board[x][y].getOwner().isPlayerOne()) {
            ++enemyCount;
        }
        if (y > 0 && this.board[x][y - 1] != null && this.board[x][y - 1].getOwner().isPlayerOne() != this.board[x][y].getOwner().isPlayerOne()) {
            ++enemyCount;
        }
        if (y < this.board[0].length - 1 && this.board[x][y + 1] != null && this.board[x][y + 1].getOwner().isPlayerOne() != this.board[x][y].getOwner().isPlayerOne()) {
            ++enemyCount;
        }
        if (x == 0 || x == this.board.length - 1 || y == 0 || y == this.board[0].length - 1) {
            return enemyCount >= 3;
        }
        return enemyCount == 4;
    }

    private boolean isCorner(Position newPosition) {
        return newPosition.getX() % 10 == 0 && newPosition.getY() % 10 == 0;
    }

    @Override
    public Piece getPieceAtPosition(Position position) {
        return this.board[position.getX()][position.getY()];
    }

    @Override
    public Player getSecondPlayer() {
        return this.attacker;
    }

    @Override
    public Player getFirstPlayer() {
        return this.defender;
    }

    @Override
    public boolean isGameFinished() {
        return this.gameFinished;
    }

    @Override
    public boolean isSecondPlayerTurn() {
        return this.attackerTurn;
    }

    @Override
    public void reset() {
        int i;
        int i2;
        this.board = new ConcretePiece[BOARD_SIZE][BOARD_SIZE];
        this.gameFinished = false;
        this.attackerTurn = true;
        this.moveHistory = new Stack();
        this.attackerDeaths = 0;
        for (i2 = 3; i2 <= 7; ++i2) {
            this.board[0][i2] = new Pawn(this.attacker);
        }
        this.board[1][5] = new Pawn(this.attacker);
        for (i2 = 3; i2 <= 7; ++i2) {
            this.board[i2][0] = new Pawn(this.attacker);
        }
        this.board[5][1] = new Pawn(this.attacker);
        for (i2 = 3; i2 <= 7; ++i2) {
            this.board[10][i2] = new Pawn(this.attacker);
        }
        this.board[9][5] = new Pawn(this.attacker);
        for (i2 = 3; i2 <= 7; ++i2) {
            this.board[i2][10] = new Pawn(this.attacker);
        }
        this.board[5][9] = new Pawn(this.attacker);
        for (i2 = 4; i2 <= 6; ++i2) {
            for (int j = 4; j <= 6; ++j) {
                this.board[i2][j] = j != 5 || i2 != 5 ? new Pawn(this.defender) : new King(this.defender);
            }
        }
        this.board[5][3] = new Pawn(this.defender);
        this.board[3][5] = new Pawn(this.defender);
        this.board[5][7] = new Pawn(this.defender);
        this.board[7][5] = new Pawn(this.defender);
        int defNumbers = 1;
        int atcNumber = 1;
        for (i = 0; i < BOARD_SIZE; ++i) {
            for (int j = 0; j < BOARD_SIZE; ++j) {
                if (this.board[j][i] == null) continue;
                ConcretePiece concretePiece = this.board[j][i];
                int numberToSet = concretePiece.getOwner().isPlayerOne() ? defNumbers++ : atcNumber++;
                concretePiece.setNumber(numberToSet);
                concretePiece.setNewPosition(new Position(j, i));
                this.positions[j][i] = new Position(j, i);
                this.positions[j][i].raisePiece(concretePiece);
            }
        }
        for (i = 0; i < BOARD_SIZE; ++i) {
            for (ConcretePiece p : this.board[i]) {
                if (p == null) continue;
                this.pieces.add(p);
            }
        }
    }

    @Override
    public void undoLastMove() {
        if (this.moveHistory.isEmpty()) {
            return;
        }
        Move lastMove = this.moveHistory.pop();
        Position to = lastMove.to();
        List<ConcretePiece> capturedPieces = lastMove.capturedPieces;
        ConcretePiece movedPiece = this.board[to.getX()][to.getY()];
        this.positions[to.getX()][to.getY()].erasePiece(movedPiece);
        movedPiece.deleteLastStep();
        if (movedPiece instanceof Pawn) {
            for (ConcretePiece p : capturedPieces) {
                ((Pawn)movedPiece).reduceKill();
            }
        }
        Position prevStep = movedPiece.getLastPosition();
        this.board[prevStep.getX()][prevStep.getY()] = movedPiece;
        this.board[to.getX()][to.getY()] = null;
        for (ConcretePiece p : capturedPieces) {
            Position prevCapturedStep = p.getLastPosition();
            int x = prevCapturedStep.getX();
            int y = prevCapturedStep.getY();
            this.board[x][y] = p;
        }
        this.attackerTurn = !this.attackerTurn;
    }

    @Override
    public int getBoardSize() {
        return BOARD_SIZE;
    }

    private record Move(Position to, List<ConcretePiece> capturedPieces) {
    }
}

