/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class GameLogicTest {
    GameLogicTest() {
    }

    static Stream<ComparisonData> comparisonData() {
        File[] inputFiles;
        File inputDirectory = new File("src/test/resources/inputs");
        File outputDirectory = new File("src/test/resources/outputs");
        if (!inputDirectory.exists() || !outputDirectory.exists()) {
            Assertions.fail((String)"Input or output directory not found");
        }
        if ((inputFiles = inputDirectory.listFiles()) == null) {
            Assertions.fail((String)"No input files found");
        }
        return Stream.of(inputFiles).filter(File::isFile).map(inputFile -> {
            String outputFileName = inputFile.getName().replace("input", "output");
            File outputFile = new File(outputDirectory, outputFileName);
            if (outputFile.exists()) {
                return new ComparisonData((File)inputFile, outputFile);
            }
            Assertions.fail((String)("Corresponding output file not found: " + outputFileName));
            return null;
        });
    }

    @ParameterizedTest
    @MethodSource(value={"comparisonData"})
    void testMove(ComparisonData comparisonData) {
        File inputFile = comparisonData.inputFile();
        File outputFile = comparisonData.outputFile();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outputStream));
        GameLogic gameLogic = new GameLogic();
        String inputContent = this.readFile(inputFile);
        List<Position> moves = GameLogicTest.parse(inputContent);
        for (int i = 0; i < moves.size() - 1; i += 2) {
            Position from = moves.get(i);
            Position to = moves.get(i + 1);
            boolean result = gameLogic.move(from, to);
            Assertions.assertTrue((boolean)result);
        }
        System.setOut(System.out);
        String capturedOutput = outputStream.toString();
        String expectedOutput = this.readFile(outputFile);
        capturedOutput = capturedOutput.replaceAll("\r", "");
        Assertions.assertEquals((Object)expectedOutput, (Object)capturedOutput);
    }

    private String readFile(File file) {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)("Error reading file: " + file.getName()));
        }
        return content.toString();
    }

    public static List<Position> parse(String movesString) {
        ArrayList<Position> positions = new ArrayList<Position>();
        Pattern pattern = Pattern.compile("\\((\\d+), (\\d+)\\)");
        Matcher matcher = pattern.matcher(movesString);
        while (matcher.find()) {
            int x = Integer.parseInt(matcher.group(1));
            int y = Integer.parseInt(matcher.group(2));
            positions.add(new Position(x, y));
        }
        return positions;
    }

    public record ComparisonData(File inputFile, File outputFile) {
    }
}

